#include "ChakraCore.au3"

_ChakraCore_Startup()

; Create runtime and context objects
Global $hRuntime = _ChakraCore_CreateRuntime(0)
Global $hContext = _ChakraCore_CreateContext($hRuntime)

; Set the current execution context
_ChakraCore_SetCurrentContext($hContext)

; Execute!
$hOutput = _ChakraCore_RunScript(FileRead("Example 1.js"), 0)

; Get the number from JsValue pointer
$iOutput = _ChakraCore_GetNumber($hOutput)
ConsoleWrite("JavaScript Output: "&$iOutput&@CRLF)

; Clean up
_ChakraCore_DisposeRuntime($hRuntime)

_ChakraCore_Shutdown()